using System;
using System.Text;

namespace hive {
    /**
    * Native 영역에서 호출되는 함수를 처리하기 위한 클래스
    */
    public class HIVEUnityPluginNativeCallbackProcessor : IHIVEUnityPluginNativeCallbackProcessor {
        public void Process(String jsonParam) {
            JSONObject resJsonObject = new JSONObject (jsonParam);

			String className = null;
			resJsonObject.GetField (ref className, "class");

			if ("Analytics".Equals (className)) {
				Analytics.executeEngine (resJsonObject);
			}
			else if("Configuration".Equals(className)){
				Configuration.executeEngine (resJsonObject);
			}
			else if("AuthV4".Equals(className)){
				AuthV4.executeEngine(resJsonObject);
			}
			else if("SocialHive".Equals(className)){
				SocialHive.executeEngine (resJsonObject);
			}
			else if("SocialFacebook".Equals(className)){
				SocialFacebook.executeEngine (resJsonObject);
			}
			else if("SocialGoogle".Equals(className)){
				SocialGoogle.executeEngine (resJsonObject);
			}
			else if("Promotion".Equals(className)){
				Promotion.executeEngine (resJsonObject);
			}
			else if("Push".Equals(className)){
				Push.executeEngine (resJsonObject);
			}
			else if("IAPV4".Equals(className)){
				IAPV4.executeEngine (resJsonObject);
			}
			else if("PlatformHelper".Equals(className)){
				PlatformHelper.executeEngine(resJsonObject);
			}
			// else if("UserEngagement".Equals(className)){
			// 	UserEngagement.executeEngine(resJsonObject);
			// }
#if !UNITY_EDITOR && UNITY_ANDROID
			else if("ProviderGoogle".Equals(className)){
				ProviderGoogle.executeEngine(resJsonObject);
			}
#elif !UNITY_EDITOR && UNITY_IPHONE
			else if("ProviderApple".Equals(className)){
				ProviderApple.executeEngine(resJsonObject);
			}
#endif // !UNITY_EDITOR && UNITY_ANDROID or !UNITY_EDITOR && UNITY_IPHONE
			else if("AuthV4Helper".Equals(className)){
				AuthV4.Helper.executeEngine(resJsonObject);
			}
			else if("SocialV4".Equals(className)) {
				SocialV4.executeEngine(resJsonObject);
			}
			else if("DataStore".Equals(className)) {
				DataStore.executeEngine(resJsonObject);
			}
			else if("MatchMaking".Equals(className)) {
				MatchMaking.executeEngine(resJsonObject);
			}
			else if("Chat".Equals(className)) {
				Chat.executeEngine(resJsonObject);
			}
        }
    }
}
